<?php

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Kit;
use Elementor\Core\Kits\Documents\Tabs\Tab_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Liquid_Global_Blog extends Tab_Base {

	public function __construct( $parent ) {
		parent::__construct( $parent );

		Controls_Manager::add_tab( $this->get_id(), $this->get_title() );
	}

	public function get_id() {
		return 'liquid-blog-kit';
	}

	public function get_title() {
		return __( 'Blog', 'logistics-hub-core' );
	}

	public function get_group() {
		return 'settings';
	}

	public function get_icon() {
		return 'eicon-archive';
	}

	public function get_help_url() {
		return 'https://docs.liquid-themes.com/';
	}

	protected function register_tab_controls() {

		$this->start_controls_section(
			'section_' . $this->get_id() . '_archives',
			[
				'label' => esc_html__('General Blog', 'logistics-hub-core'),
				'tab' => $this->get_id(),
			]
		);

		$this->add_control(
			'liquid_blog_date_format',
			[
				'label' => esc_html__( 'Blog Date Format', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'ago',
				'options' => [
					'ago' => esc_html__( 'Time ago', 'logistics-hub-core' ),
					'wp' => esc_html__( 'Wordpress Date Format (WP Settings > General)', 'logistics-hub-core' ),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_' . $this->get_id() . '_single',
			[
				'label' => esc_html__('Blog Single', 'logistics-hub-core'),
				'tab' => $this->get_id(),
			]
		);

		$this->add_control(
			'liquid_blog_single_post_style',
			[
				'label' => esc_html__( 'Post style', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'default' => 'wide',
				'options' => [
					'wide' => esc_html__( 'Wide', 'logistics-hub-core' ),
					'modern-full-screen' => esc_html__( 'Modern Full Screen', 'logistics-hub-core' ),
				],
			]
		);

		$this->add_control(
			'liquid_blog_single_post_image_overlay_color',
			[
				'label' => esc_html__( 'Post image overlay', 'logistics-hub-core' ),
				'type' => 'liquid-color',
				'selectors' => [
					'{{WRAPPER}} .lqd-post-media .lqd-post-cover-overlay' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'liquid_blog_single_meta_enable',
			[
				'label' => esc_html__( 'Post meta', 'logistics-hub-core' ),
				'description' => esc_html__( 'Switch on to display the post meta on single post pages.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'logistics-hub-core' ),
				'label_off' => esc_html__( 'Hide', 'logistics-hub-core' ),
				'return_value' => 'on',
				'default' => 'on',
			]
		);

		$this->add_control(
			'liquid_blog_single_author_box_enable',
			[
				'label' => esc_html__( 'Author meta', 'logistics-hub-core' ),
				'description' => esc_html__( 'Switch on to display the author info box on single post pages.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'logistics-hub-core' ),
				'label_off' => esc_html__( 'Hide', 'logistics-hub-core' ),
				'return_value' => 'on',
				'default' => 'on',
			]
		);

		$this->add_control(
			'liquid_blog_single_reading_time',
			[
				'label' => esc_html__( 'Post reading time', 'logistics-hub-core' ),
				'description' => esc_html__( 'Will display the text about time needs to read the article.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'logistics-hub-core' ),
				'label_off' => esc_html__( 'Hide', 'logistics-hub-core' ),
				'return_value' => 'on',
				'condition' => [
					'liquid_blog_single_author_box_enable' => 'on'
				]
			]
		);

		$this->add_control(
			'liquid_blog_single_reading_time_label',
			[
				'label' => __( 'Label', 'logistics-hub-core' ),
				'description' => __( 'Add label after the reading time', 'logistics-hub-core' ),
				'default' => __( 'min read', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'condition' => [
					'liquid_blog_single_reading_time' => 'on'
				]
			]
		);

		$this->add_control(
			'liquid_blog_single_author_role_enable',
			[
				'label' => esc_html__( 'Author role', 'logistics-hub-core' ),
				'description' => esc_html__( 'Turn on to display the author role in info box below posts.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'logistics-hub-core' ),
				'label_off' => esc_html__( 'Hide', 'logistics-hub-core' ),
				'return_value' => 'on',
			]
		);

		$this->add_control(
			'liquid_blog_single_navigation_enable',
			[
				'label' => esc_html__( 'Neighbour posts', 'logistics-hub-core' ),
				'description' => esc_html__( 'Switch on to display the previous post and next post on single post pages.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'logistics-hub-core' ),
				'label_off' => esc_html__( 'Hide', 'logistics-hub-core' ),
				'return_value' => 'on',
				'default' => 'on',
			]
		);

		$this->add_control(
			'liquid_blog_single_archive_link',
			[
				'label' => esc_html__( 'Blog archive link', 'logistics-hub-core' ),
				'description' => esc_html__( 'Custom link to post on navigation to link to the default blog archive.', 'logistics-hub-core' ),
				'type' => Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'logistics-hub-core' ),
				'default' => [
					'url' => '',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'liquid_blog_single_related_enable',
			[
				'label' => esc_html__( 'Related posts', 'logistics-hub-core' ),
				'description' => esc_html__( 'Display the related posts on single posts.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'logistics-hub-core' ),
				'label_off' => esc_html__( 'Hide', 'logistics-hub-core' ),
				'return_value' => 'on',
				'default' => 'on',
			]
		);

		$this->add_control(
			'liquid_blog_single_related_title',
			[
				'label' => esc_html__( 'Title of related posts', 'logistics-hub-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__( 'You may also like', 'logistics-hub-core' ),
				'condition' => [
					'liquid_blog_single_related_enable' => 'on',
				],
			]
		);

		$this->add_control(
			'liquid_blog_single_related_number',
			[
				'label' => esc_html__( 'Related posts quantity', 'logistics-hub-core' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 2,
				'max' => 100,
				'step' => 1,
				'default' => 3,
				'condition' => [
					'liquid_blog_single_related_enable' => 'on',
				],
			]
		);

		$this->add_control(
			'liquid_blog_single_social_box_enable',
			[
				'label' => esc_html__( 'Social sharing', 'logistics-hub-core' ),
				'description' => esc_html__( 'Display the social sharing box on single post pages.', 'logistics-hub-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'logistics-hub-core' ),
				'label_off' => esc_html__( 'Hide', 'logistics-hub-core' ),
				'return_value' => 'on',
				'default' => 'on',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_' . $this->get_id() . '_social_links',
			[
				'label' => esc_html__('Blog Social Share Links', 'logistics-hub-core'),
				'tab' => $this->get_id(),
			]
		);

		$social_links_items = new \Elementor\Repeater();

		$social_links_items->add_control(
			'type',
			[
				'label' => esc_html__( 'Type', 'logistics-hub-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'custom',
				'label_block' => true,
				'options' => [
					'custom' => esc_html__( 'Custom', 'logistics-hub-core' ),
					'facebook' => esc_html__( 'Facebook', 'logistics-hub-core' ),
					'twitter'  => esc_html__( 'Twitter', 'logistics-hub-core' ),
					'linkedin' => esc_html__( 'Linkedin', 'logistics-hub-core' ),
					'pinterest' => esc_html__( 'Pinterest', 'logistics-hub-core' ),
				],
			]
		);

		$social_links_items->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'logistics-hub-core' ),
				'type' => Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'logistics-hub-core' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'label_block' => true,
				'condition' => [
					'type' => 'custom'
				]
			]
		);

		$social_links_items->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'logistics-hub-core' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-wordpress',
					'library' => 'fa-brands',
				],
				'recommended' => [
					'fa-brands' => [
						'android',
						'apple',
						'behance',
						'bitbucket',
						'codepen',
						'delicious',
						'deviantart',
						'digg',
						'dribbble',
						'elementor',
						'facebook',
						'flickr',
						'foursquare',
						'free-code-camp',
						'github',
						'gitlab',
						'globe',
						'houzz',
						'instagram',
						'jsfiddle',
						'linkedin',
						'medium',
						'meetup',
						'mix',
						'mixcloud',
						'odnoklassniki',
						'pinterest',
						'product-hunt',
						'reddit',
						'shopping-cart',
						'skype',
						'slideshare',
						'snapchat',
						'soundcloud',
						'spotify',
						'stack-overflow',
						'steam',
						'telegram',
						'thumb-tack',
						'tripadvisor',
						'tumblr',
						'twitch',
						'twitter',
						'viber',
						'vimeo',
						'vk',
						'weibo',
						'weixin',
						'whatsapp',
						'wordpress',
						'xing',
						'yelp',
						'youtube',
						'500px',
					],
					'fa-solid' => [
						'envelope',
						'link',
						'rss',
					],
				]
			]
		);

		$this->add_control(
			'liquid_blog_single_social_links',
			[
				'label' => esc_html__( 'Social Links', 'logistics-hub-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $social_links_items->get_controls(),
				'default' => [
					[
						'icon' => [
							'value' => 'fab fa-facebook',
							'library' => 'fa-brands',
						],
						'type' => 'facebook'
					],
					[
						'icon' => [
							'value' => 'fab fa-twitter',
							'library' => 'fa-brands',
						],
						'type' => 'twitter'
					],
					[
						'icon' => [
							'value' => 'fab fa-pinterest',
							'library' => 'fa-brands',
						],
						'type' => 'pinterest'
					],
					[
						'icon' => [
							'value' => 'fab fa-linkedin',
							'library' => 'fa-brands',
						],
						'type' => 'linkedin'
					],
				],
				'title_field' => '{{{ elementor.helpers.renderIcon( this, icon, {}, "i", "panel" ) || \'<i class="{{ icon }}" aria-hidden="true"></i>\' }}}',

			]
		);

		$this->add_control(
			'liquid_blog_single_social_link_color',
			[
				'label' => esc_html__( 'Color', 'logistics-hub-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .lqd-social-icon-blog li a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'liquid_blog_single_social_link_hover_color',
			[
				'label' => esc_html__( 'Hover color', 'logistics-hub-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .lqd-social-icon-blog li a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

	}

}

new Liquid_Global_Blog( Kit::class );

add_action(
	'elementor/kit/register_tabs',
	function( $kit ) {
		$kit->register_tab( 'liquid-blog-kit', Liquid_Global_Blog::class );
	}
);
